package easik.sketch.util.Export.Components;

import java.util.ArrayList;
import java.util.LinkedList;

import easik.sketch.util.Export.ExportConstants;


/**
 * A class to hold the elements of a unique key.  Elements are stored as a linked list of names of attributes
 * which constitute the unique key.  This class should only be used for SQL database generation as it does not 
 * contain full functionality.
 * 
 * @author Vera Ranieri 2006
 * @since 2006-06-14 Vera Ranieri
 * @version 2006-06-14 Vera Ranieri
 *
 */
public class ExportUniqueKey {
	/**
	 * The attributes involved in the unique key
	 */
	private LinkedList<String> _elements;
	
	/**
	 * Constructor.  Initializes <it>elements</it>
	 */
	public ExportUniqueKey(){
		_elements = new LinkedList<String>();
	}

	/**
	 * Adds a new element to the unique key by adding the name of the attribute that is part of the unique key to the list
	 * of all elements which form the unique key.
	 * 
	 * @param e The name of the element which forms a part of the unique key
	 */
	public void addElement(String e){
		//removes any spaces
		String name = e.replace(' ', '_');
		
		_elements.add(name);
	}
	
	/**
	 * Getter method for the linked list of all names of attributes which form this unique key
	 * 
	 * @return The linked list of all attributes which form this key
	 */
	public LinkedList getElements(){
		return _elements;
	}
	
	/**
	 * Formats the unique key string for SQL exportation.  The table t passed to the method is the table for which 
	 * unique keys must be determined.  Does not contain relevant information about key definition and primary key
	 * definition 
	 * 
	 * @param t The table for which unique keys must be determined
	 * @return The unique key string formatted for SQL
	 */
	public static String getUniqueKeyString(ExportTable t){
		
		String unique = "";
		
		ArrayList keys = t.getUniqueKeys();
		LinkedList elements;
		
		int numKeys = keys.size();
		int size;
		
		for(int i = 0; i< numKeys; i++){
			unique += ExportConstants.UNIQUE;
			elements = ((ExportUniqueKey)keys.get(i)).getElements();
			size = elements.size();
			for(int j = 0; j<size; j++ ){
				unique += (String)elements.get(j) + ", ";
			}
			//remove last comma and space
			unique = unique.substring(0, unique.length()-2);
			
			unique += "), \n";
		}
		return unique;
	}
}
